#!/bin/bash
# Check defined nspawn container in /var/lib/machines and
# start every container that is enabled.
# The network-online.target in systemd-nspawn@ service file
# does not (yet) wait for libvirt managed interfaces.
# We need to start it decidely when the libvirt bridge is ready.

# $1 : network name, eg. Default
# $2 : one of "start" | "started" | "port-created"
# $3 : always "begin"
# see  https://libvirt.org/hooks.html

set -o nounset

network="$1"
operation="$2"
suboperation="$3"

ctdir="/var/lib/machines/"
ctstartlog="/var/log/nspawn-ct-startup.log"

echo " P1: $1 - P2: $2 - P3: $3   @  $(date)  " 
echo "     "                                    >  $ctstartlog
echo "======================================="  >>  $ctstartlog
echo " Begin  $(date)  "                       >>  $ctstartlog
echo " P1: $1 - P2: $2 - P3: $3 "               >> $ctstartlog

if [ "$network" == "default" ]; then
  if [ "$operation" == "started" ] && [ "$suboperation" == "begin" ]; then
    for file in  $ctdir/* ; do 
      echo "     "             >> $ctstartlog
      echo "Checking: $file "  >> $ctstartlog
      echo " Filename: $(basename  $file)  "   >> $ctstartlog
      echo " Status: $(systemctl is-enabled systemd-nspawn@$(basename $file) ) "  >> $ctstartlog

      if [ "$(systemctl is-enabled systemd-nspawn@$(basename $file) )" == "enabled" ]; then
        echo " Starting Container $(basename  $file) ...  "  >> $ctstartlog
        systemctl  start  systemd-nspawn@$(basename $file)
        echo " Container $(basename  $file) started  "  >> $ctstartlog
      fi
    done
  fi
fi

